import {
  CanActivate,
  ExecutionContext,
  Injectable,
} from '@nestjs/common';

import SupabaseService from './auth/supabase.service';

const supabaseService = new SupabaseService();

@Injectable()
export class AuthGuard implements CanActivate {

  async canActivate(context: ExecutionContext) {
    const request = context.switchToHttp().getRequest();
    
    const validate = await supabaseService.validateUserSession(request.session);

    console.log(validate);
    
    return request.session ? true : false; 
  }
}