import {
  BusinessTypes,
  Platform,
} from 'src/types';

import { ApiProperty } from '@nestjs/swagger';

export class SignUpCustomerDto {
  @ApiProperty()
  email: string; 
  
  @ApiProperty()
  name: string;

  @ApiProperty()
  phoneNumber: string;

  @ApiProperty()
  dateOfBirth: string;

  @ApiProperty()
  password: string;

  @ApiProperty()
  address: string;   

  @ApiProperty()
  city: string;   

  @ApiProperty()
  state: string;     
  
  @ApiProperty()
  country: string;   

  @ApiProperty()
  postalCode: string;
}

export class SignUpMerchantDto {
  @ApiProperty()
  email: string; 
  
  @ApiProperty()
  name: string;

  @ApiProperty()
  phoneNumber: string;

  @ApiProperty()
  dateOfBirth: string;

  @ApiProperty()
  password: string;

  @ApiProperty()
  profilePic: string;

  @ApiProperty()
  ratings: number;
  
  @ApiProperty()
  active: boolean;

  @ApiProperty()
  entityName: string;

  @ApiProperty({ enum: BusinessTypes })
  businessType?: BusinessTypes;

  @ApiProperty()
  businessRegistrationNumber?: string;

  @ApiProperty()
  contractSigneeName?: string;

  @ApiProperty()
  contractSigneeNRIC?: string;
  
  @ApiProperty()
  address: string;   

  @ApiProperty()
  city: string;   

  @ApiProperty()
  state: string;     
  
  @ApiProperty()
  country: string;   

  @ApiProperty()
  postalCode: string;

  @ApiProperty()
  latitude: number;

  @ApiProperty()
  longitude: number;
}

export class SignInDto {
  @ApiProperty()
  email: string; 
  
  @ApiProperty()
  password: string;

  @ApiProperty({ enum: Platform })
  platform: Platform;
}

export class ResetPasswordDto {
  @ApiProperty()
  currentPassword: string; 
  
  @ApiProperty()
  newPassword: string;

  @ApiProperty()
  confirmNewPassword: string;
}

export class EmailResetPasswordDto {
  @ApiProperty()
  email: string; 
}

export class PasswordResetOtpDto {
  @ApiProperty()
  email: string; 
  
  @ApiProperty()
  passwordResetOtp: string; 
}

export class SetNewPasswordDto {
  @ApiProperty()
  newPassword: string;

  @ApiProperty()
  confirmNewPassword: string;
}