import { Injectable } from '@nestjs/common';

import prisma from '../prisma';
import {
  SignUpCustomerDto,
  SignUpMerchantDto,
} from './auth.dto';

@Injectable()
export class AuthService {
  constructor() {}

  async createCustomer(data: SignUpCustomerDto) {
    const role = await prisma.role.findFirst({
      where : {
        name: 'Customer'
      }
    });

    if(!role) {
      throw new Error('Role Customer Not Found');
    }

    return prisma.user.create({ 
      data : {
        email: data.email,
        name: data.name,
        phoneNumber: data.phoneNumber,
        dateOfBirth: new Date(data.dateOfBirth),
        role : {
          connect : {
            id: role.id
          }
        },
        address : {
          create : {
            address : data.address,
            city : data.city,
            state : data.state,
            country : data.country,
            postalCode : data.postalCode
          }
        }
      }
    });
  }

  async createMerchant(data: SignUpMerchantDto) {
    const role = await prisma.role.findFirst({
      where : {
        name: 'Merchant'
      }
    });

    if(!role) {
      throw new Error('Role Merchant Not Found');
    }

    return prisma.user.create({ 
      data : {
        email: data.email,
        name: data.name,
        phoneNumber: data.phoneNumber,
        dateOfBirth: new Date(data.dateOfBirth),
        role : {
          connect : {
            id: role.id
          }
        },
        merchant : {
          create : {
            name: data.entityName,                                    
            businessType: data.businessType,
            ...(data.businessRegistrationNumber && {
              businessRegistrationNumber: data.businessRegistrationNumber
            }),  
            ...(data.contractSigneeName && {
              contractSigneeName: data.contractSigneeName
            }), 
            ...(data.contractSigneeNRIC && {
              contractSigneeNRIC: data.contractSigneeNRIC
            }),                                
            address : {
              create : {
                address : data.address,
                city : data.city,
                state : data.state,
                country : data.country,
                postalCode : data.postalCode
              }
            }
          }
        },
      }
    });
  }

  async findUserByEmail(email: string) {
    return prisma.user.findUnique({
      where:{
        email,
      },
      include: {
        role: true,
        address: true
      }
    });
  }
 
}
