import { Body, Controller, HttpCode, HttpStatus, Post } from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { CreditHistoryDto } from './credit-history.dto';
import { CreditHistoryService } from './credit-history.service';

@ApiTags('credit-history')
@Controller('credit-history')
export class CreditHistoryController {
    constructor(
        private creditHistoryService: CreditHistoryService
    ) { }

    @Post('')
    @HttpCode(HttpStatus.OK)
    async findCreditHistory(@Body() creditHistoryDto: CreditHistoryDto) {

        const creditHistory = await this.creditHistoryService.getUserCreditHistory(creditHistoryDto);

        return { data: creditHistory, message: 'Find Credit History' }
    }
}
