import { ApiProperty } from '@nestjs/swagger';

export class CreditHistoryDto {

    @ApiProperty()
    userId: string;

    @ApiProperty({ required: false })
    page?: number = 1;

    @ApiProperty({ required: false })
    numPerPage?: number = 5;

    @ApiProperty({ required: false, enum: ['asc', 'desc'], default: 'desc' })
    orderBy?: string = 'desc';

    @ApiProperty({ required: false })
    startDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'

    @ApiProperty({ required: false })
    endDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'
}
