import { Injectable } from '@nestjs/common';
import { CreditHistoryDto } from './credit-history.dto';
import prisma from '../prisma';

@Injectable()
export class CreditHistoryService {
    constructor() { }

    async getUserCreditHistory(creditHistoryDto: CreditHistoryDto) {

        const whereClause: any = {};

        if (creditHistoryDto.startDate) {

            whereClause.createdAt = {
                ...whereClause.createdAt,
                gte: new Date(creditHistoryDto.startDate),
            };
        }

        if (creditHistoryDto.endDate) {

            whereClause.createdAt = {
                ...whereClause.createdAt,
                lte: new Date(creditHistoryDto.endDate),
            };
        }

        const creditWithHistory = await prisma.credit.findUnique({
            where: {
                userId: creditHistoryDto.userId,
            },
            include: {
                history: {
                    where: whereClause,
                    orderBy: {
                        createdAt: creditHistoryDto.orderBy as 'asc' | 'desc',
                    },
                    skip: (creditHistoryDto.page - 1) * creditHistoryDto.numPerPage,
                    take: creditHistoryDto.numPerPage,
                },
            },
        });

        // Get the total count of credit history records
        const totalCount = await prisma.creditHistory.count({
            where: {
                creditId: creditWithHistory.id,
                ...whereClause,
            },
        });

        return {
            creditWithHistory,
            totalCount,
        };
    }

}
