import { Body, Controller, Get, HttpCode, HttpStatus, Param, Post } from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { CreditService } from './credit.service';
import { UserService } from 'src/user/user.service';
import { isEmpty } from 'src/utils';

@ApiTags('Credit')
@Controller('credit')
export class CreditController {
    constructor(
        private creditService: CreditService,
        private userService: UserService
    ) { }

    @Get(':id')
    @HttpCode(HttpStatus.OK)
    async findBalanceByUserId(@Param('id') userId: string) {

        const credit = await this.creditService.getUserBalance(userId);
        const user = await this.userService.findOne(userId);

        // check if credit data is empty, create new wallet for user.
        if (isEmpty(credit) && !isEmpty(user)) {

            console.log(`Found no registered Credit User & User is active user! Registering new Credit for ${user?.name}.`)
            return { data: await this.creditService.create(user), message: 'Find Credit Balance' }
        }

        return { data: credit, message: 'Find Credit Balance' }
    }

    // TODO add create Transaction when reload , cancelled, refunded

    // TODO add billplz integration
}
