// src/main.ts

import { NestFactory } from '@nestjs/core';
import {
  DocumentBuilder,
  SwaggerModule,
} from '@nestjs/swagger';

import { PrismaModel } from './_gen/prisma-class';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);
  // enable validation
  app.useGlobalPipes(new ValidationPipe());

  const config = new DocumentBuilder()
    .setTitle('Merchant API')
    .setDescription('API for managing merchants')
    .setVersion('1.0')
    .build();
  const document = SwaggerModule.createDocument(app, config, {extraModels: [...PrismaModel.extraModels]});
  SwaggerModule.setup('api', app, document);

  await app.listen(3000);
}
bootstrap();
