import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsOptional, IsNotEmpty } from 'class-validator';

export enum TransactionType {
    PURCHASE = "PURCHASE",
    LOYALTY_POINT = "LOYALTY_POINT",
    EARNED = "EARNED",
    REFUND = "REFUND",
    REFUNDED = "REFUNDED",
    REDEMPTION = "REDEMPTION"
}

export enum DeliveryMethod {
    DELIVERY = "DELIVERY",
    PICKUP = "PICKUP",
    REDEEM_AT_STORE = "REDEEM_AT_STORE"
}

export class LoyaltyPointHistoryDto {
    @ApiProperty()
    userId: string;

    @ApiProperty({ required: false })
    page?: number = 1;

    @ApiProperty({ required: false })
    numPerPage?: number = 5;

    @ApiProperty({ required: false, enum: ['asc', 'desc'], default: 'desc' })
    orderBy?: string = 'desc';

    @ApiProperty({ required: false })
    startDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'

    @ApiProperty({ required: false })
    endDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'
}

export class CreateProductDto {
    @ApiProperty({ type: String })
    name: string;

    @ApiProperty({ type: String })
    category: string;

    @ApiProperty({ type: String })
    description: string;

    @ApiProperty({ type: String })
    price: string;

    @ApiProperty({ type: String })
    pointsCost: string;

    @ApiProperty({ required: false })
    images: string[];

    @ApiProperty({ type: String })
    stock: string;

    @ApiProperty({ required: false })
    tagId?: string;
}

export class UpdateProductDto {
    @ApiProperty({ required: false })
    name?: string;

    @ApiProperty({ required: false })
    description?: string;

    @ApiProperty({ required: false })
    price?: string;

    @ApiProperty({ required: false })
    pointsCost?: string;

    @ApiProperty({ type: [String], required: false })
    images?: string[];

    @ApiProperty({ required: false })
    stock?: string;

    @ApiProperty({ required: false })
    tagId?: string;
}

export class RedeemProductDto {

    @ApiProperty({ required: true })
    @IsNotEmpty()
    userId: string;

    @ApiProperty({ required: true })
    @IsNotEmpty()
    productId: string;

    @ApiProperty({ enum: TransactionType })
    paymentMethod: TransactionType = TransactionType.LOYALTY_POINT;

    @ApiProperty({ enum: DeliveryMethod })
    // @IsEnum(DeliveryMethod)
    deliveryMethod: DeliveryMethod = DeliveryMethod.DELIVERY;

    @ApiProperty({ required: false })
    @IsOptional()
    deliveryAddress?: string;

    @ApiProperty({ required: false })
    @IsOptional()
    merchantId?: string;
}

export class MarkAsCollectedDto {
    @ApiProperty()
    id: string;

    @ApiProperty({ required: false })
    courierType?: string;

    @ApiProperty({ required: false })
    shippingNo?: string;

    @ApiProperty({ required: false })
    remarks?: string;

    @ApiProperty({ required: false })
    collected?: boolean;
}

export class ListProductsDto {

    @ApiProperty({ required: false, default: 1 })
    page?: number = 1;

    @ApiProperty({ required: false, default: 10 })
    numPerPage?: number = 10;

    @ApiProperty({ required: false })
    category?: string;

    @ApiProperty({ required: false })
    search?: string;

    @ApiProperty({ required: false, enum: ['asc', 'desc'], default: 'desc' })
    sortOrder?: 'asc' | 'desc' = 'desc';

    @ApiProperty({ required: false, enum: ['price', 'createdAt'], default: 'createdAt' })
    sortBy?: 'price' | 'createdAt' = 'createdAt';
}

export class UserRedemptionDto {
    @ApiProperty()
    userId: string;

    @ApiProperty({ required: false })
    page?: number = 1;

    @ApiProperty({ required: false })
    numPerPage?: number = 5;

    @ApiProperty({ required: false, enum: ['asc', 'desc'], default: 'desc' })
    orderBy?: string = 'desc';

    @ApiProperty({ required: false })
    startDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'

    @ApiProperty({ required: false })
    endDate?: string; // ISO string format eg. '2023-01-01T00:00:00.000Z'
}