import { ApiProperty } from '@nestjs/swagger';

export class OptionDto {
  @ApiProperty()
  id: string;

  @ApiProperty()
  name: string;

  @ApiProperty()
  price: number;

  @ApiProperty()
  active: boolean;
}

export class MenuOptionDto {
  @ApiProperty()
  id: string;
  
  @ApiProperty()
  name: string;

  @ApiProperty()
  isRequired: boolean;

  @ApiProperty()
  min: number;

  @ApiProperty()
  max: number;

  @ApiProperty()
  active: boolean;

  @ApiProperty({ type: [OptionDto] })
  option: OptionDto[];
}

export class CreateMenuDto {
  @ApiProperty()
  merchantId: string;
  
  @ApiProperty()
  name: string; 

  @ApiProperty()
  image: Express.Multer.File;
  
  @ApiProperty()
  basePrice: string;

  @ApiProperty()
  category: string;

  @ApiProperty()
  active: boolean;

  @ApiProperty()
  description: string;

  @ApiProperty({ type: [MenuOptionDto] })
  menuOption: string;
}

export class UpdateMenuDto {
  @ApiProperty()
  merchantId: string;
  
  @ApiProperty()
  name: string; 

  @ApiProperty()
  image: Express.Multer.File;
  
  @ApiProperty()
  basePrice: number;

  @ApiProperty()
  category: string;

  @ApiProperty()
  active: boolean;

  @ApiProperty()
  description: string;

  @ApiProperty({ type: [MenuOptionDto] })
  menuOption: MenuOptionDto[];
}

export class CheckMenuAvailabilityDto {
  @ApiProperty({ type: [String] })
  menuIds: string[]
}

export class MenuImgUploadDto{
  @ApiProperty()
  menuId: string;

  @ApiProperty()
  imagefile: Express.Multer.File;
}