import { BusinessTypes } from 'src/types';

import { ApiProperty } from '@nestjs/swagger';

export class CreateUpdateMerchantDto {
  @ApiProperty()
  name: string; 

  @ApiProperty()
  storyDescription: string;

  @ApiProperty()
  image?: string; 

  @ApiProperty()
  openingHours: string;
  
  @ApiProperty()
  active: boolean;

  @ApiProperty({ enum: BusinessTypes })
  businessType?: BusinessTypes;

  @ApiProperty()
  businessRegistrationNumber?: string;

  @ApiProperty()
  contractSigneeName?: string;

  @ApiProperty()
  contractSigneeNRIC?: string;
  
  @ApiProperty()
  address: string;   

  @ApiProperty()
  city: string;   

  @ApiProperty()
  state: string;     
  
  @ApiProperty()
  country: string;   

  @ApiProperty()
  postalCode: string;

  @ApiProperty()
  latitude: number;

  @ApiProperty()
  longitude: number;

  @ApiProperty()
  email: string;
}

export class GetMerchantDTO {
  @ApiProperty()
  id: string;

  @ApiProperty()
  latitude: number;

  @ApiProperty()
  longitude: number;
}

export class NearbyShopDTO {
  @ApiProperty()
  latitude: number;

  @ApiProperty()
  longitude: number;
}

export class ReviewMerchantDTO {
  @ApiProperty()
  reviewerId: string;

  @ApiProperty()
  orderId: string;

  @ApiProperty()
  rating: number;

  @ApiProperty()
  review: string;
}

export class MerchantImgUploadDto{
  @ApiProperty()
  merchantId: string;

  @ApiProperty()
  imagefile: Express.Multer.File;
}

export class UpdateOpeningHours{
  @ApiProperty()
  openingHours: object;
}

export class MerchantUpdateAddressDto{
  @ApiProperty()
  address: string;   

  @ApiProperty()
  city: string;   

  @ApiProperty()
  state: string;     
  
  @ApiProperty()
  country: string;   

  @ApiProperty()
  postalCode: string;

  @ApiProperty()
  latitude: number;

  @ApiProperty()
  longitude: number;
}