// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { OrderDetails } from './order-details.dto';

import { OrderDetailsService } from './order-details.service';

@ApiTags('OrderDetails')
@Controller('orderDetails')
export class OrderDetailsController {
  constructor(private orderDetailsService: OrderDetailsService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: OrderDetails) {
    const data = await this.orderDetailsService.create(reqData);
    return { data: data, message: 'Order Details Created'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.orderDetailsService.findAll();
    return { data: data, message: 'Order Details Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.orderDetailsService.findOne(id);
    return { data: data, message: 'Order Details Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData) {
    const data = await this.orderDetailsService.update(id, reqData);
    return { data: data, message: 'Order Details Updated'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.orderDetailsService.remove(id);
    return { data: data, message: 'Order Details Deleted'}
  }
}
