import { Injectable } from '@nestjs/common';

import prisma from '../prisma';

@Injectable()
export class OrderDetailsService {
  constructor() {}

  async create(data) {
    return prisma.orderDetails.create({ data });
  }

  async findAll() {
    return prisma.orderDetails.findMany();
  }

  async findOne(id: string) {
    return prisma.orderDetails.findUnique({ where: { id } });
  }

  async update(id: string, data) {
    return prisma.orderDetails.update({ where: { id }, data });
  }

  async remove(id: string) {
    return prisma.orderDetails.delete({ where: { id } });
  }
}
