// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';

import { CreateUpdateOrderDto, UpdateOrderStatusdto, userOrderHistoryDto, merchantOrderHistoryDto } from './order.dto';
import { OrderService } from './order.service';

@ApiTags('Order')
@Controller('order')
export class OrderController {
  constructor(private orderService: OrderService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: CreateUpdateOrderDto) {
    const data = await this.orderService.create(reqData);
    return { data: data, message: 'Order Created'}
  }

  @Post('user/orderHistory')
  @HttpCode(HttpStatus.OK)
  async findByUserId(@Body() reqData: userOrderHistoryDto) {
    const data = await this.orderService.findByUserId(reqData);
    return { data: data, message: 'Order History By User id'}
  }
  
  @Post('merchant/orderHistory')
  @HttpCode(HttpStatus.OK)
  async findByMerchantId(@Body() reqData: merchantOrderHistoryDto) {
    const data = await this.orderService.findByMerchantId(reqData);
    return { data: data, message: 'Order History By User id'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.orderService.findAll();
    return { data: data, message: 'Order Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.orderService.findOne(id);
    return { data: data, message: 'Order Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData: CreateUpdateOrderDto) {
    const data = await this.orderService.update(id, reqData);
    return { data: data, message: 'Order Updated'}
  }

  @Put(':id/status')
  @HttpCode(HttpStatus.OK)
  async updateStatus(@Param('id') id: string, @Body() reqData: UpdateOrderStatusdto) {
    const data = await this.orderService.updateStatus(id, reqData);
    return { data: data, message: 'Order Updated Status'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.orderService.remove(id);
    return { data: data, message: 'Order Removed'}
  }
}
