import { ApiProperty } from '@nestjs/swagger';

export class OrderDetailOptions {
  @ApiProperty()
  menuOptionId: string;

  @ApiProperty()
  optionId: string;
}

export class OrderDetails {
  @ApiProperty()
  quantity: number;

  @ApiProperty()
  menuId: string;

  @ApiProperty()
  orderId?: string;

  @ApiProperty({ type: [OrderDetailOptions] })
  orderDetailOptions: OrderDetailOptions[];
}

export class CreateUpdateOrderDto {
  @ApiProperty()
  orderTime: Date;

  @ApiProperty()
  pickupTime: Date;

  @ApiProperty()
  userId: string;

  @ApiProperty()
  totalAmount?: number;

  @ApiProperty()
  transactionId?: string;

  @ApiProperty()
  merchantId?: string;

  @ApiProperty()
  vehicleId?: string;

  @ApiProperty({ type: [OrderDetails] })
  orderDetails: OrderDetails[];

  @ApiProperty()
  referenceId?: string;
}

export class UpdateOrderStatusdto {
  @ApiProperty()
  status?: string;
}

export class userOrderHistoryDto {
  @ApiProperty()
  userId: string;

  @ApiProperty()
  page?: number;

  @ApiProperty()
  numPerPage?: number;
}

export class merchantOrderHistoryDto {
  @ApiProperty()
  merchantId: string;

  @ApiProperty()
  page?: number;

  @ApiProperty()
  numPerPage?: number;

  @ApiProperty()
  status: string;

  @ApiProperty()
  userId: string;

  @ApiProperty()
  orderTime: Date;

  @ApiProperty()
  pickupTime: Date;
}