export interface BillplzConfig {
    apiKey: string;
    collectionId: string;
    billplzBaseUrl: string;
}

export const BILLPLZ_CONFIG = 'BILLPLZ_CONFIG';

export const BillplzConfigProvider = {
    provide: BILLPLZ_CONFIG,
    useValue: {
      apiKey: process.env.BILLPLZ_SANDBOX_MODE ? process.env.BILLPLZ_SANDBOX_API_KEY : process.env.BILLPLZ_API_KEY,
      collectionId: process.env.BILLPLZ_SANDBOX_MODE ? process.env.BILLPLZ_SANDBOX_COLLECTION_ID : process.env.BILLPLZ_COLLECTION_ID,
      billplzBaseUrl: process.env.BILLPLZ_SANDBOX_MODE ? process.env.BILLPLZ_SANDBOX_URL : process.env.BILLPLZ_BASE_URL,
    } as BillplzConfig,
  };

