import { HttpModule } from '@nestjs/axios';
import { Module } from '@nestjs/common';
import { CreditHistoryModule } from 'src/credit-history/credit-history.module';
import { CreditModule } from 'src/credit/credit.module';
import { BillplzConfigProvider } from './config/BillplzConfig';
import { PaymentController } from './payment.controller';
import { PaymentService } from './payment.service';

@Module({
  imports: [
    CreditModule,
    CreditHistoryModule,
    HttpModule.register({
      timeout: 5000,
      maxRedirects: 5,
    }),
  ],
  controllers: [PaymentController],
  providers: [PaymentService, BillplzConfigProvider],
})
export class PaymentModule {}
