// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';

import { CreateUpdateRatingDto } from './rating.dto';
import { RatingService } from './rating.service';

@ApiTags('Rating')
@Controller('rating')
export class RatingController {
  constructor(private RatingService: RatingService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: CreateUpdateRatingDto) {
    const data = await this.RatingService.create(reqData);
    return { data: data, message: 'Rating Created'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.RatingService.findAll();
    return { data: data, message: 'Rating Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.RatingService.findOne(id);
    return { data: data, message: 'Rating Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData: CreateUpdateRatingDto) {
    const data = await this.RatingService.update(id, reqData);
    return { data: data, message: 'Rating Updated'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.RatingService.remove(id);
    return { data: data, message: 'Rating Deleted'};
  }
}
