import { Injectable } from '@nestjs/common';

import prisma from '../prisma';
import { CreateUpdateRatingDto } from './rating.dto';

@Injectable()
export class RatingService {
  constructor() {}

  async create(data: CreateUpdateRatingDto) {
    return prisma.rating.create({ 
      data : {
        merchantId: data.merchantId,
        reviewerId: data.reviewerId,
        rating: data.rating,
        review: data.review
      }
    });
  }

  async findAll() {
    return prisma.rating.findMany();
  }

  async findOne(id: string) {
    return prisma.rating.findUnique({ where: { id } });
  }

  async update(id: string, data: CreateUpdateRatingDto) {
    return prisma.rating.update({ 
      where: { id },
      data : {
        merchantId: data.merchantId,
        rating: data.rating,
        review: data.review
      }
    });
  }

  async remove(id: string) {
    return prisma.rating.delete({ where: { id } });
  }
}
