// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';

import { CreateUpdateTransactionDto } from './transaction.dto';
import { TransactionService } from './transaction.service';

@ApiTags('Transaction')
@Controller('transaction')
export class TransactionController {
  constructor(private transactionService: TransactionService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: CreateUpdateTransactionDto) {
    const data = await this.transactionService.create(reqData);
    return { data: data, message: 'Transaction Created'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.transactionService.findAll();
    return { data: data, message: 'Transaction Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.transactionService.findOne(id);
    return { data: data, message: 'Transaction Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData: CreateUpdateTransactionDto) {
    const data = await this.transactionService.update(id, reqData);
    return { data: data, message: 'Transaction Updated'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.transactionService.remove(id)
    return { data: data, message: 'Transaction Removed'}
  }
}
