import { Injectable } from '@nestjs/common';

import prisma from '../prisma';
import { CreateUpdateTransactionDto } from './transaction.dto';

@Injectable()
export class TransactionService {
  constructor() {}

  async create(data: CreateUpdateTransactionDto) {
    return prisma.transaction.create({ 
      data : {
        totalAmount: data.totalAmount,
        paymentTime: new Date(),  
        paymentMethod: data.paymentMethod,
        orderId: data.orderId
      }
     });
  }

  async findAll() {
    return prisma.transaction.findMany();
  }

  async findOne(id: string) {
    return prisma.transaction.findUnique({ where: { id } });
  }

  async update(id: string, data: CreateUpdateTransactionDto) {
    return prisma.transaction.update({ 
      where : {
        id: id
      },
      data : {
        totalAmount: data.totalAmount,
        paymentTime: new Date(),  
        paymentMethod: data.paymentMethod,
        orderId: data.orderId
      }
     });
  }

  async remove(id: string) {
    return prisma.transaction.delete({ where: { id } });
  }
}
