// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
  UseInterceptors,
  UploadedFile
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';
import { FileInterceptor } from '@nestjs/platform-express';
import { CreateUpdateUserDto, UpdateVehicleDto, UserImgUploadDto } from './user.dto';
import { UserService } from './user.service';

@ApiTags('User')
@Controller('user')
export class UserController {
  constructor(private userService: UserService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: CreateUpdateUserDto) {
    const data = await this.userService.create(reqData);
    return { data: data, message: 'User Created'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.userService.findAll();
    return { data: data, message: 'User Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.userService.findOne(id);
    return { data: data, message: 'User Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData: CreateUpdateUserDto) {
    const data = await this.userService.update(id, reqData);
    return { data: data, message: 'User Updated'}
  }

  @Post(':id/vehicle')
  @HttpCode(HttpStatus.OK)
  async updateVehicle(@Param('id') id: string, @Body() reqData: UpdateVehicleDto) {
    const data = await this.userService.updateVehicle(id, reqData);
    return { data: data, message: 'User Vehicle Updated'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.userService.remove(id);
    return { data: data, message: 'User Remove'}
  }

  @Post('upload')
  @UseInterceptors(FileInterceptor('imagefile'))
  @HttpCode(HttpStatus.OK)
  async uploadMenuImg(@UploadedFile() imagefile: Express.Multer.File, @Body() reqData: UserImgUploadDto) {
    const data = await this.userService.uploadMenuImage(imagefile, reqData);
    
    return { data: data, message: 'User Image Upload Successful' };
  }
}
