// src/menu/menu.controller.ts

import {
  Body,
  Controller,
  Delete,
  Get,
  HttpCode,
  HttpStatus,
  Param,
  Post,
  Put,
} from '@nestjs/common';
import { ApiTags } from '@nestjs/swagger';

import { CreateUpdateVehicleDto } from './vehicle.dto';
import { VehicleService } from './vehicle.service';

@ApiTags('Vehicle')
@Controller('user')
export class VehicleController {
  constructor(private vehicleService: VehicleService) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  async create(@Body() reqData: CreateUpdateVehicleDto) {
    const data = await this.vehicleService.create(reqData);
    return { data: data, message: 'Vehicle Created'}
  }

  @Get()
  @HttpCode(HttpStatus.OK)
  async findAll() {
    const data = await this.vehicleService.findAll();
    return { data: data, message: 'Vehicle Find All'}
  }

  @Get(':id')
  @HttpCode(HttpStatus.OK)
  async findOne(@Param('id') id: string) {
    const data = await this.vehicleService.findOne(id);
    return { data: data, message: 'Vehicle Find One'}
  }

  @Put(':id')
  @HttpCode(HttpStatus.OK)
  async update(@Param('id') id: string, @Body() reqData: CreateUpdateVehicleDto) {
    const data = await this.vehicleService.update(id, reqData);
    return { data: data, message: 'Vehicle Updated'}
  }

  @Delete(':id')
  @HttpCode(HttpStatus.OK)
  async remove(@Param('id') id: string) {
    const data = await this.vehicleService.remove(id);
    return { data: data, message: 'Vehicle Remove'}
  }
}
