import { Injectable } from '@nestjs/common';

import prisma from '../prisma';
import { CreateUpdateVehicleDto } from './vehicle.dto';

@Injectable()
export class VehicleService {
  constructor() {}

  async create(data: CreateUpdateVehicleDto) {
    return prisma.userVehicle.create({ 
      data : {
        plate: data.plate,
        user : {
          connect : {
            id : data.userId
          }
        }
    }});
  }

  async findAll() {
    return prisma.userVehicle.findMany({
    });
  }

  async findOne(id: string) {
    return prisma.userVehicle.findUnique({ 
      where: { id }
    });
  }

  async update(id: string, data: CreateUpdateVehicleDto) {
    return prisma.userVehicle.update({ 
      where: { id }, 
      data:{
        plate: data.plate
      } 
    })
  };

  async remove(id: string) {
    return prisma.userVehicle.delete({ where: { id } });
  }
}
